include rauc.mk

AT91_SD_BOOT_PARTSIZE:=64
FAT32_BLOCK_SIZE:=1024
FAT32_BLOCKS:=$(shell echo \
  $$(($(AT91_SD_BOOT_PARTSIZE)*1024*1024/$(FAT32_BLOCK_SIZE))))
DATAFS_PARTSIZE:=$(shell echo \
  $$(($(CONFIG_TARGET_DATAFS_PARTSIZE)*1024*1024)))

KERNEL_LOADADDR := 0x20008000
SD_UBOOT_ENV := uboot-env.txt uboot-rauc.txt
NAND_UBOOT_ENV := uboot-env-nand.txt uboot-rauc-nand.txt

define Device/default-nand
  BLOCKSIZE := 256KiB
  PAGESIZE := 4096
  SUBPAGESIZE := 4096
  MKUBIFS_OPTS := -m $$(PAGESIZE) -e 248KiB -c 2048
endef

define Build/kernel-itb
    $(CP) $(KDIR)/$(DEVICE_NAME)-fit-zImage.itb $(dir $@)/kernel.itb
endef

define Build/ubifs-image
    mkfs.ubifs $(MKUBIFS_OPTS) -r $(TARGET_DIR) -o $(dir $@)/rootfs.ubifs
	$(CP) $(dir $@)/rootfs.ubifs $(KDIR)/$(DEVICE_NAME)-rootfs.ubifs
endef

define Build/ubi-image
    @echo "Building UBI image $@"
	cp ./ubinize.cfg $(dir $@)/ubinize.cfg
    cd $(dir $@) && ubinize -m $(PAGESIZE) -p $(BLOCKSIZE) \
        -o $(notdir $@) ./ubinize.cfg

	$(call Build/uboot-env,$@,nand,$(NAND_UBOOT_ENV))
	$(CP) $@-nand-uboot.env $(BIN_DIR)/u-boot-$(DEVICE_DTS:at91-%=%)_nand/uboot.env
	cat pmecc.bin $(BIN_DIR)/at91bootstrap-$(DEVICE_DTS:at91-%=%)_nand_uboot/at91bootstrap.bin > $(BIN_DIR)/at91bootstrap-$(DEVICE_DTS:at91-%=%)_nand_uboot/at91bootstrap-nand.bin
endef

define Build/prepare-nand-configs
	echo "/dev/mtd2 0x0 0x4000 0x40000" > $(TARGET_DIR)/etc/fw_env.config
	sed -i 's/^compatible=.*/compatible=$(DEVICE_NAME)/' $(TARGET_DIR)/etc/rauc/system.conf.nand
    cp $(TARGET_DIR)/etc/rauc/system.conf.nand $(TARGET_DIR)/etc/rauc/system.conf
	echo -n openwrt-trout-sama5-$(DEVICE_NAME)-ubifs-$(RAUC_BUNDLE_FILE_NOEXT)-nand.raucb > $(TARGET_DIR)/etc/rauc/version
endef


define Device/sdimage
  IMAGES += sdcard.img.gz
  IMAGE/sdcard.img.gz := at91-sdcard
endef

define Image/Prepare
  $(call Image/Prepare/rauc-sysconf)
endef

define Build/uboot-env
  echo board=$(DEVICE_NAME) > $(1)-$(2)-uboot-env.txt
  echo board_name="$(firstword $(SUPPORTED_DEVICES))" >> $(1)-$(2)-uboot-env.txt
  for env in $(3); do \
    cat $${env} >> $(1)-$(2)-uboot-env.txt; \
  done
  mkenvimage -s 0x4000 -o $(1)-$(2)-uboot.env $(1)-$(2)-uboot-env.txt
endef

define Build/at91-sdcard
  $(if $(findstring ext4,$@), \
  rm -f $@.boot
  mkfs.fat -C $@.boot $(FAT32_BLOCKS)

  mcopy -i $@.boot \
	$(KDIR)/$(DEVICE_NAME)-fit-zImage.itb \
	::zImage-fit_A.itb

  mcopy -i $@.boot \
	$(KDIR)/$(DEVICE_NAME)-fit-zImage.itb \
	::zImage-fit_B.itb

  mcopy -i $@.boot \
	$(BIN_DIR)/u-boot-$(DEVICE_DTS:at91-%=%)_mmc/u-boot.bin \
	::u-boot.bin

  mcopy -i $@.boot \
	$(BIN_DIR)/at91bootstrap-$(DEVICE_DTS:at91-%=%)sd_uboot/at91bootstrap.bin \
	::BOOT.bin

  $(call Build/uboot-env,$@,sd,$(SD_UBOOT_ENV))

  mcopy -i $@.boot $@-sd-uboot.env ::uboot.env
  $(CP) $@-sd-uboot.env $(BIN_DIR)/u-boot-$(DEVICE_DTS:at91-%=%)_mmc/uboot.env

  make_ext4fs -L data \
	-l $(DATAFS_PARTSIZE) \
	-b $(CONFIG_TARGET_EXT4_BLOCKSIZE) \
	-m 0 \
	$(if $(CONFIG_TARGET_EXT4_JOURNAL),,-J) \
	$(if $(SOURCE_DATE_EPOCH),-T $(SOURCE_DATE_EPOCH)) \
	$@.data

  ./gen_at91_sdcard_img.sh \
	$@.img \
	$@.boot \
	$(IMAGE_ROOTFS) \
  $@.data \
	$(AT91_SD_BOOT_PARTSIZE) \
	$(CONFIG_TARGET_ROOTFS_PARTSIZE) \
	$(CONFIG_TARGET_DATAFS_PARTSIZE)

  gzip -nc9 $@.img > $@

  rm -f $@.img $@.boot $@.data $@-sd-uboot.env $@-sd-uboot-env.txt)
endef

define Device/trout/kernel
  DEVICE_DTS := at91-sama5d27_trout
  DTB_SIZE := 128k
  SUPPORTED_DEVICES := trout,sama5d27-trout
  KERNEL_NAME := zImage
  KERNEL_SIZE := 6144k
  KERNEL_INSTALL :=1
  KERNEL_SUFFIX := -fit-zImage.itb
  KERNEL = kernel-bin | gzip | fit gzip $$(KDIR)/image-$$(DEVICE_DTS).dtb
endef

DEFAULT_DEVICE_PACKAGES := kmod-usb2 kmod-pwm-atmel kmod-gpio-beeper \
	kmod-i2c-core libi2c \
	kmod-spi-dev \
	kmod-input-gpio-keys kmod-leds-gpio kmod-ledtrig-gpio kmod-ledtrig-activity \
	libgpiod \
	kmod-fs-vfat nand-utils \
	kmod-usb-net-cdc-ether kmod-usb-serial kmod-usb-serial-option kmod-usb-serial-wwan \
	rng-tools \
	uboot-envtools \
	bash

DISPLAY_DEVICE_PACKAGES := kmod-backlight kmod-backlight-pwm \
    kmod-drm kmod-drm-kms-helper libdrm \
    kmod-fb \
    kmod-input-touchscreen-edt-ft5x06 \
    lvgl-lib 

DEVELOPMENT_PACKAGES := openssh-sftp-server picocom i2c-tools mdio-tools spidev-test

define Device/generic-sdimage
  $(Device/Default)
  DEVICE_MODEL := Generic
  DEFAULT := n
  DEVICE_PACKAGES := $(DEFAULT_DEVICE_PACKAGES)
  DEVICE_ROOTFS_TAR_GZ:= $(BIN_DIR)/$(IMG_PREFIX)$(if $(PROFILE_SANITIZED),-$(PROFILE_SANITIZED))-rootfs.tar.gz

  UBOOT_ENV+=uboot-env.txt uboot-rauc.txt
  $(Device/trout/kernel)
  $(Device/rauc-bundle)
  $(Device/sdimage)
endef
TARGET_DEVICES += generic-sdimage

define Device/trout-sdimage
  $(Device/Default)
  DEVICE_MODEL := Trout
  DEFAULT := n
  DEVICE_PACKAGES := $(DEFAULT_DEVICE_PACKAGES)

  DEVICE_ROOTFS_TAR_GZ:= $(BIN_DIR)/$(IMG_PREFIX)$(if $(PROFILE_SANITIZED),-$(PROFILE_SANITIZED))-rootfs.tar.gz

  UBOOT_ENV+=uboot-env.txt uboot-rauc.txt
  $(Device/trout/kernel)
  $(Device/rauc-bundle)
  $(Device/sdimage)
endef

define Device/trout-nand
  $(Device/default-nand)
  DEVICE_MODEL := Trout NAND
  DEVICE_DTS := at91-sama5d27_trout
  DEVICE_PACKAGES := $(DEFAULT_DEVICE_PACKAGES)
  FILESYSTEMS := ubifs
  IMAGES += nand.ubi
  IMAGE/nand.ubi := prepare-nand-configs | ubifs-image | kernel-itb | ubi-image
  IMAGES += $(RAUC_BUNDLE_FILE_NOEXT)-nand.raucb
  IMAGE/$(RAUC_BUNDLE_FILE_NOEXT)-nand.raucb := prepare-nand-configs | ubifs-image | kernel-itb | ubi-image | rauc-bundle-nand
  $(Device/trout/kernel)
endef

# TBD enable when nand is added to trout
#TARGET_DEVICES += trout-nand 
TARGET_DEVICES += trout-sdimage