ifneq ($(CONFIG_TARGET_IMAGE_RAUC),)
RAUC_PARENT_GITREPO:=$(TOPDIR)/..
RAUC_GITSHA:=$(shell git -C $(RAUC_PARENT_GITREPO) rev-parse --short=8 HEAD)
RAUC_DATE_STR:=$(shell date +%Y.%m.%d)
RAUC_VERSION_STR:=$(RAUC_DATE_STR).$(RAUC_GITSHA)
RAUC_BUNDLE_FILE_NOEXT:=$(RAUC_VERSION_STR)

RAUC_UPDATE_URL:=$(CONFIG_TARGET_IMAGE_RAUC_UPDATE_URL)
RAUC_UPDATE_URL_TARGET:=$(call qstrip,$(RAUC_UPDATE_URL)/$(call tolower,$(subst DEVICE_,,$(CONFIG_TARGET_PROFILE))))
RAUC_CONFIG_FILE_VERSION:=$(call qstrip,$(IMG_PREFIX)-$(call tolower,$(subst DEVICE_,,$(CONFIG_TARGET_PROFILE)))-ext4-$(RAUC_BUNDLE_FILE_NOEXT).raucb)

# convert relative paths to cert and key to absolute ones relative to OpenWrt directory
RAUC_CONFIG_CERT_PATH:=$(call qstrip,$(CONFIG_TARGET_IMAGE_RAUC_CERT))
RAUC_CONFIG_PRIV_KEY_PATH:=$(call qstrip,$(CONFIG_TARGET_IMAGE_RAUC_PRIV_KEY))
RAUC_CERT_FILE_ABS_PATH:=$(if $(patsubst /%,,$(RAUC_CONFIG_CERT_PATH)),$(TOPDIR)/$(RAUC_CONFIG_CERT_PATH),$(RAUC_CONFIG_CERT_PATH))
RAUC_KEY_FILE_ABS_PATH:=$(if $(patsubst /%,,$(RAUC_CONFIG_PRIV_KEY_PATH)),$(TOPDIR)/$(RAUC_CONFIG_PRIV_KEY_PATH),$(RAUC_CONFIG_PRIV_KEY_PATH))

SD_UBOOT_ENV := uboot-env.txt uboot-rauc.txt
NAND_UBOOT_ENV := uboot-env-nand.txt uboot-rauc-nand.txt

define Device/rauc-bundle
  IMAGES += $(RAUC_BUNDLE_FILE_NOEXT).raucb
  IMAGE/$(RAUC_BUNDLE_FILE_NOEXT).raucb := rauc-bundle
endef

define rauc_manifest
[update]
compatible=$(PROFILE_SANITIZED)
version=$(RAUC_VERSION_STR)

[bundle]
format=verity

[hooks]
filename=hook

[image.rootfs]
filename=$(notdir $(DEVICE_ROOTFS_TAR_GZ))
hooks=pre-install;post-install
endef

define rauc_manifest_nand
[update]
compatible=$(DEVICE_NAME)
version=$(RAUC_VERSION_STR)

[bundle]
format=verity

[hooks]
filename=nand-hook

[image.rootfs]
filename=$(DEVICE_NAME)-rootfs.ubifs
hooks=pre-install;post-install
endef

define Image/Prepare/rauc-sysconf
	echo -n $(RAUC_CONFIG_FILE_VERSION) > $(TARGET_DIR)/etc/rauc/version
	sed -i 's/^image_update_url=.*/image_update_url=$(subst /,\/,$(RAUC_UPDATE_URL_TARGET))/' $(TARGET_DIR)/etc/rauc/image-update.conf
	sed -i 's/^compatible=.*/compatible=$$(PROFILE_SANITIZED)/' $(TARGET_DIR)/etc/rauc/system.conf.sdcard
	cp $(TARGET_DIR)/etc/rauc/system.conf.sdcard $(TARGET_DIR)/etc/rauc/system.conf
endef

define Build/rauc-bundle
  -rm -r $@ $@.bundle-dir $(@)_/fs.tar* $(@)_/etc
  -mkdir $@.bundle-dir
  $(call Build/uboot-env,$@,sd,$(SD_UBOOT_ENV))
  cp $(DEVICE_ROOTFS_TAR_GZ) $(BIN_DIR)/u-boot-$(DEVICE_DTS:at91-%=%)_mmc/u-boot.bin rauc/hook $@.bundle-dir
  mv $(@)-sd-uboot.env $@.bundle-dir/uboot.env
  cp $(KDIR)/$(DEVICE_NAME)-fit-zImage.itb $@.bundle-dir/zImage-fit.itb
  echo $(CONFIG_TARGET_IMAGE_RAUC_EXCLUDED_CONF) > $@.bundle-dir/excluded-config-files.txt
  mkdir -p $(@)_/etc/rauc
  echo -n $(notdir $@) > $(@)_/etc/rauc/version
  echo "image_update_url=$(RAUC_UPDATE_URL)/$(DEVICE_NAME)" > $(@)_/etc/rauc/image-update.conf
  echo "download_dir=/tmp" >> $(@)_/etc/rauc/image-update.conf
  zcat $@.bundle-dir/$(notdir $(DEVICE_ROOTFS_TAR_GZ)) > $(@)_/fs.tar
  tar -rf $(@)_/fs.tar -C $(@)_ etc/
  gzip -nc9 $(@)_/fs.tar > $@.bundle-dir/$(notdir $(DEVICE_ROOTFS_TAR_GZ))
  $(eval $(call shexport,rauc_manifest))
  $(SH_FUNC) var2file "$(call shvar,rauc_manifest,$@)" $@.bundle-dir/manifest.raucm 
  rauc --cert $(RAUC_CERT_FILE_ABS_PATH) --key $(RAUC_KEY_FILE_ABS_PATH) bundle $@.bundle-dir/ $@
  #-rm -r $@.bundle-dir $(@)_
endef

define Build/rauc-bundle-nand
  -rm -r $@ $@.bundle-dir
  -mkdir $@.bundle-dir
  cp $(KDIR)/$(DEVICE_NAME)-rootfs.ubifs $(KDIR)/tmp/kernel.itb rauc/nand-hook $@.bundle-dir/
  echo $(CONFIG_TARGET_IMAGE_RAUC_EXCLUDED_CONF) > $@.bundle-dir/excluded-config-files.txt
  mkdir -p $(@)_/etc/rauc
  echo -n $(notdir $@) > $(@)_/etc/rauc/version
  echo "image_update_url=$(RAUC_UPDATE_URL)/$(DEVICE_NAME)" > $(@)_/etc/rauc/image-update.conf
  echo "download_dir=/tmp" >> $(@)_/etc/rauc/image-update.conf
  $(eval $(call shexport,rauc_manifest_nand))
  $(SH_FUNC) var2file "$(call shvar,rauc_manifest_nand,$@)" $@.bundle-dir/manifest.raucm 
  rauc --cert $(RAUC_CERT_FILE_ABS_PATH) --key $(RAUC_KEY_FILE_ABS_PATH) bundle $@.bundle-dir/ $@
endef

endif
