#!/bin/sh

LOGFILE="/var/log/bg95log"
DEVICE_TTY=ttyUSB2

#basic configuration
#Set baud rate
echo "AT+IPR=115200" | socat -R $LOGFILE - /dev/${DEVICE_TTY}

#Set echo mode to off
echo "ATE0" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200

#Configure bg95 and print information to console
echo "AT+QCFG=\"fast/poweroff\",25,1" | socat -R $LOGFILE - /dev/${DEVICE_TTY}
echo "AT+QCFGEXT=\"usbnet\",\"ecm\"" | socat -R $LOGFILE - /dev/${DEVICE_TTY}
echo "AT+CEREG=1" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200

#Define a new PGP context
echo "AT+CGDCONT=1,\"IP\",\"iot0119.com.attz\"" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200

#Attempt to activate the context
echo "AT+CGACT=1,1" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200
echo "AT+CGPADDR=1" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200
echo "AT+COPS=0" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200
echo "AT+CGDCONT" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200
echo "AT+COPS?" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200
echo "AT+QCSQ" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200
echo "AT+CREG?" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200
echo "AT+CGPADDR" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200

SIM_INSERTED=$(echo AT+CPIN? | socat -R $LOGFILE - /dev/${DEVICE_TTY} | grep READY)
if [ -z "${SIM_INSERTED}" ] ; then
    echo "SIM not inserted" >> $LOGFILE
    exit 1
fi

#Determine bg95 information
export BG95_CIMI=$(echo "AT+CIMI" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200 | grep -o '[0-9]*')
export BG95_CCID=$(echo "AT+CCID" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200 | grep -o '[0-9]*')
export BG95_IMEI=$(echo "AT+GSN" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200 | grep -o '[0-9]*')
if [ -z "${BG95_CIMI}" ] || [ -z "${BG95_CCID}" ] || [ -z "${BG95_IMEI}" ] ; then
    echo "Failed to get BG95 information" >> $LOGFILE
    exit 1
fi
logger -t bg95 "IMEI: ${BG95_IMEI} CIMI: ${BG95_CIMI} CCID: ${BG95_CCID}"

#Set UCI values based on values above
type_present=$(uci -q get system.@bg95[0])
if [ "$type_present" = "" ]; then
    logger -t bg95 "Adding system bg95 to uci"
    uci add system bg95 
fi

if [ -z ${BG95_CIMI} ]; then 
    logger -t bg95 CIMI is unset
else 
    uci set system.@bg95[0].cimi=${BG95_CIMI}
fi
if [ -z ${BG95_CCID} ]; then 
    logger -t bg95 CIMI is unset
else 
    uci set system.@bg95[0].ccid=${BG95_CCID}
fi
if [ -z ${BG95_IMEI} ]; then 
    logger -t bg95 CIMI is unset
else 
    uci set system.@bg95[0].imei=${BG95_IMEI}
fi

#Reboot modem 1 more time
echo "AT+CFUN=1,1" | socat -R $LOGFILE - /dev/${DEVICE_TTY},b115200

uci commit system

exit 0
