'use strict';
'require view';
'require form';
'require tools.widgets as widgets';

return view.extend({
	render: function() {
		var m, s, o;

		m = new form.Map('olsrd2', 'OLSRD2 Daemon');
		m.tabbed = true;
		s = m.section(form.GridSection, 'interface', _('interface configuration section'));
		s.anonymous = true;
		s.addremove = true;
		s.addbtntitle = _('Add new interface...');
		s.tab('general', _('General Settings'));
		s.tab('oonf', _('OONF RFC5444 Plugin'));
		s.tab('nhdp', _('NHDP Plugin'));
		s.tab('link', _('Link Config Plugin'));
		s.modaltitle = function(section_id) {
			return _('Interfaces') + ' » ' + section_id.toUpperCase();
		};

		o = s.taboption("general", form.Flag, "ignore", _("Enabled"));
		o.enabled = "0";
		o.disabled = "1";
		o.rmempty = false;
		o = s.taboption("general", form.Value, "ifname", _("Network"), _("The interface OLSR2 should serve."));
		o.datatype = "string";
		o = s.taboption("oonf", form.DynamicList, "acl", _("acl defines the IP addresses that are allowed to use the RFC5444 socket."), _("ip6prefix, ip4prefix, default_accept, default_reject"));
		o.datatype = "string";
		o.optional = true;
		o.modalonly = true;
		o = s.taboption("oonf", form.DynamicList, "bindto", _("bindto defines the IP addresses which the RFC5444 socket will be bound to."), _("ip6prefix, ip4prefix, default_accept, default_reject"));
		o.datatype = "string";
		o.optional = true;
		o.modalonly = true;
		o = s.taboption("oonf", form.Value, "multicast_v4", _("multicast_v4 defines the IPv4 multicast address used for RFC5444 packets."), _("ip4addr"));
		o.datatype = "ip4addr";
		o.placeholder = "224.0.0.109";
		o.optional = true;
		o.modalonly = true;
		o = s.taboption("oonf", form.Value, "multicast_v6", _("multicast_v6 defines the IPv6 multicast address used for RFC5444 packets."), _("ip6addr"));
		o.datatype = "ip6addr";
		o.placeholder = "ff02::6d";
		o.optional = true;
		o.modalonly = true;
		o = s.taboption("oonf", form.Value, "dscp", _("dscp defines the DSCP value set for each outgoing RFC5444 packet. The value must be between 0 and 252 without fractional digits. The value should be a multiple of 4."), _("0-255"));
		o.optional = true;
		o.placeholder = 192;
		o.datatype = "range(0,255)";
		o.modalonly = true;
		o = s.taboption("oonf", form.Value, "rawip", _("rawip defines if the interface should put RFC5444 packets directly into IP headers (skipping the UDP header)."), _("bool"));
		o.optional = true;
		o.rmempty = true;
		o.datatype = "bool";
		o.modalonly = true;
		o = s.taboption("nhdp", form.DynamicList, "ifaddr_filter", _("ifaddr_filter defines the IP addresses that are allowed to NHDP interface addresses."), _("ip6prefix, ip4prefix, default_accept, default_reject"));
		o.datatype = "string";
		o.optional = true;
		o.modalonly = true;
		o = s.taboption("nhdp", form.Value, "hello_validity", _("hello_validity defines the time the local HELLO messages will be valid for the neighbors."), _(">0.1 s"));
		o.optional = true;
		o.placeholder = 20.0;
		o.datatype = "and(min(0.1), ufloat)";
		o.modalonly = true;
		o = s.taboption("nhdp", form.Value, "hello_interval", _("hello_interval defines the time between two HELLO messages on the interface."), _(">0.1 s"));
		o.optional = true;
		o.placeholder = 2.0;
		o.datatype = "and(min(0.1), ufloat)";
		o.modalonly = true;
		o = s.taboption("link", form.Value, "rx_bitrate", _("rx_bitrate"));
		o.optional = true;
		o.rmempty = false;
		o.placeholder = "1G";
		o.datatype = "string";
		o = s.taboption("link", form.Value, "tx_bitrate", _("tx_bitrate"));
		o.optional = true;
		o.rmempty = false;
		o.placeholder = "1G";
		o.datatype = "string";
		o = s.taboption("link", form.Value, "rx_max_bitrate", _("rx_max_bitrate"));
		o.optional = true;
		o.rmempty = false;
		o.placeholder = "1G";
		o.datatype = "string";
		o.modalonly = true;
		o = s.taboption("link", form.Value, "tx_max_bitrate", _("tx_max_bitrate"));
		o.optional = true;
		o.rmempty = false;
		o.placeholder = "1G";
		o.datatype = "string";
		o.modalonly = true;
		o = s.taboption("link", form.Value, "rx_signal", _("rx_signal"));
		o.optional = true;
		o.rmempty = false;
		o.placeholder = "1G";
		o.datatype = "string";
		o.modalonly = true;

		return m.render();
	}
});
