# Internationalization (i18n)

See [online wiki](https://github.com/openwrt/luci/wiki/i18n) for latest version.

## Use translation function

### Translations in JavaScript

Wrap translatable strings with `_()` e.g.  `_('string to translate')` and the `i18n-scan.pl` and friends will correctly identify these strings for translation.

If you have multi line strings you can split them with concatenation:
```js
var mystr = _('this string will translate ' +
	'correctly even though it is ' +
	'a multi line string!');
```

You may also use line continuations `\` syntax:

```js
var mystr = _('this string will translate \
	correctly even though it is \
	a multi line string');
```

Usually if you have multiple sentences you may need to use a line break. Use the `<br />` HTML tag like so:
```js
var mystr = _('Port number.') + '<br />' +
	_('E.g. 80 for HTTP');
```
Use `<br />` and **not** `<br>` or `<br/>`.

If you have a link inside a translation, move its attributes out of a translation key:
```js
var mystr = _('For further information <a %s>check the wiki</a>')
	.format('href="https://openwrt.org/docs/" target="_blank" rel="noreferrer"')
```
This will generate a full link with HTML `For further information <a href="https://openwrt.org/docs/" target="_blank" rel="noreferrer">check the wiki</a>`. The `noreferrer` is important so that it is opened in a new tab (`target="_blank"`).

### Translations in LuCI lua+html templates
Use the `<%: text to translate %>` as documented on [Templates](./Templates.md)

### Translations in Lua controller code and Lua CBIs
As hinted at in the Templates doc, the `%:` invokes a `translate()` function.
In most controller contexts, this is already available for you, but if necessary, is available for include in `luci.i18n.translate`


## Translation files
Translations are saved in the folder `po/` within each individual LuCI component directory, e.g. `applications/luci-app-acl/po/`.
The template is in `po/templates/<package>.pot`.
The individual language translation files can be found at `po/[lang]/[package].po`.

In order to use the commands below you need to have the `gettext` utilities (`msgcat`, `msgfmt`, `msgmerge`) installed on your system.
On Debian/Ubuntu, install them with `sudo apt install gettext`.

### Initialize po files

When you add or update an app, run from your `applications/luci-app-acl/` app folder:

    ../../build/i18n-add-language.sh

This creates the skeleton .po files for all available languages open for translation for your app.

Or from the luci repo root:

    ./build/i18n-add-language.sh

This creates the skeleton .po files for all existing languages open for translation for all sub-folders.

### Rebuild po files (for existing languages)
After you make changes to a package, run:

    ./build/i18n-sync.sh applications/[application]

Example:

    ./build/i18n-sync.sh applications/luci-app-acl

This only updates those language .po files that already exist in `applications/luci-app-acl/po/`. See the previous step to add a new language.

Note: the directory argument can be omitted to update all po template and po files.


Some packages share translation files, in this case you need to scan through all their folders:

    ./build/i18n-scan.pl applications/[package-1] applications/[package-2] applications/[package-n] > [location of shared template]/[application].pot

This is what the `mkbasepot.sh` script does for the `luci-base` module:

    ./build/i18n-scan.pl \
        modules/luci-base modules/luci-compat modules/luci-lua-runtime \
        modules/luci-mod-network modules/luci-mod-status modules/luci-mod-system \
        protocols themes \
    > modules/luci-base/po/templates/base.pot

*Note:* The translation catalog for the base system covers multiple components. Use the following commands to update it:

    ./build/mkbasepot.sh
    ./build/i18n-update.pl

### LMO files
The `*.po` files are big so Luci needs them in a compact compiled [LMO format](./LMO.md).
Luci reads `*.lmo` translations from the `/usr/lib/lua/luci/i18n/` folder.
E.g. `luci-app-acl` has an Arabic translation in `luci-i18n-acl-ar` package that installs `/usr/lib/lua/luci/i18n/acl.ar.lmo` file.

In order to quickly convert a single `.po` file to `.lmo` file for testing on the target system use the `po2lmo` utility.
You will need to compile it from the `luci-base` module:

     $ cd modules/luci-base/src/
     $ make po2lmo
     $ ./po2lmo
     Usage: ./po2lmo input.po output.lmo

Now you can compile and upload the translation:

     ./po2lmo ../../../applications/luci-app-acl/po/ar/acl.po ./acl.ar.lmo
     scp ./acl.ar.lmo root@192.168.1.1:/usr/lib/lua/luci/i18n/

You can change languages in [System /Language and Style](http://192.168.1.1/cgi-bin/luci/admin/system/system) and check the translation.
