#!/usr/bin/perl
# zoneinfo2ucode.pl - Make ucode module from /usr/share/zoneinfo
# Execute from within root of Luci feed, usually feeds/luci

use strict;

my %TZ;

my $tzdin  = $ARGV[0] || "/usr/share/zoneinfo";
my $tzdout = $ARGV[1] || "./modules/luci-base/ucode/zoneinfo.uc";

local $/ = "\012";
open( ZTAB, "< $tzdin/zone.tab" ) || die "open($tzdin/zone.tab): $!";

while( ! eof ZTAB ) {
	chomp( my $line = readline ZTAB );
	next if $line =~ /^#/ || $line =~ /^\s+$/;

	my ( undef, undef, $zone, @comment ) = split /\s+/, $line;

	printf STDERR "%-40s", $zone;

	if( open ZONE, "< $tzdin/$zone" ) {
		seek ZONE, -2, 2;

		while( tell(ZONE) > 0 ) {
			read ZONE, my $char, 1;
			( $char eq "\012" ) ? last : seek ZONE, -2, 1;
		}

		chomp( my $tz = readline ZONE );
		print STDERR ( $tz || "(no tzinfo found)" ), "\n";
		close ZONE;

		if( $tz ) {
			$zone =~ s/_/ /g;
			$TZ{$zone} = $tz;
		}
	}
	else
	{
		print STDERR "open($tzdin/$zone): $!\n";
	}
}

close ZTAB;

# Add Etc/GMT zones from manually as they are not in zone.tab
$TZ{"Etc/GMT"} = "GMT0";
$TZ{"Etc/GMT-1"} = "<+01>-1";
$TZ{"Etc/GMT-2"} = "<+02>-2";
$TZ{"Etc/GMT-3"} = "<+03>-3";
$TZ{"Etc/GMT-4"} = "<+04>-4";
$TZ{"Etc/GMT-5"} = "<+05>-5";
$TZ{"Etc/GMT-6"} = "<+06>-6";
$TZ{"Etc/GMT-7"} = "<+07>-7";
$TZ{"Etc/GMT-8"} = "<+08>-8";
$TZ{"Etc/GMT-9"} = "<+09>-9";
$TZ{"Etc/GMT-10"} = "<+10>-10";
$TZ{"Etc/GMT-11"} = "<+11>-11";
$TZ{"Etc/GMT-12"} = "<+12>-12";
$TZ{"Etc/GMT-13"} = "<+13>-13";
$TZ{"Etc/GMT-14"} = "<+14>-14";
$TZ{"Etc/GMT+1"} = "<-01>1";
$TZ{"Etc/GMT+2"} = "<-02>2";
$TZ{"Etc/GMT+3"} = "<-03>3";
$TZ{"Etc/GMT+4"} = "<-04>4";
$TZ{"Etc/GMT+5"} = "<-05>5";
$TZ{"Etc/GMT+6"} = "<-06>6";
$TZ{"Etc/GMT+7"} = "<-07>7";
$TZ{"Etc/GMT+8"} = "<-08>8";
$TZ{"Etc/GMT+9"} = "<-09>9";
$TZ{"Etc/GMT+10"} = "<-10>10";
$TZ{"Etc/GMT+11"} = "<-11>11";
$TZ{"Etc/GMT+12"} = "<-12>12";

open(O, "> $tzdout") || die "open($tzdout): $!\n";

print STDERR "Writing time zones to $tzdout ... ";
print O <<HEAD;
// Autogenerated by zoneinfo2ucode.pl

export default {
HEAD

foreach my $zone ( sort keys %TZ ) {
	printf O "\t'%s': '%s',\n", $zone, $TZ{$zone}
}

print O "};\n";
close O;

print STDERR "done\n";
