#!/bin/sh
# SPDX-License-Identifier: GPL-2.0-only
#
# Copyright (C) 2017 OpenWrt.org

set -x
[ $# -eq 7 ] || {
    echo "SYNTAX: $0 <file> <bootfs image> <rootfs image> <datafs image> <bootfs size> <rootfs size> <datafs size>"
    exit 1
}

OUTPUT="$1"
BOOTFS="$2"
ROOTFS="$3"
DATAFS="$4"
BOOTFSSIZE="$5"
ROOTFSSIZE="$6"
DATAFSSIZE="$7"

head=4
sect=2048

set $(ptgen -v -o $OUTPUT -h $head -s $sect -l 1024 -t c -p ${BOOTFSSIZE}M -t 83 -p ${ROOTFSSIZE}M -t 83 -p ${ROOTFSSIZE}M -t 83 -p ${DATAFSSIZE}M)

BOOTOFFSET="$(($1 / 512))"
BOOTSIZE="$(($2 / 512))"
ROOTFS1OFFSET="$(($3 / 512))"
ROOTFS1SIZE="$(($4 / 512))"
ROOTFS2OFFSET="$(($5 / 512))"
ROOTFS2SIZE="$(($6 / 512))"
DATAOFFSET="$(($7 / 512))"
DATASIZE="$(($8 / 512))"

dd bs=512 if="$BOOTFS" of="$OUTPUT" seek="$BOOTOFFSET" conv=notrunc
dd bs=512 if="$ROOTFS" of="$OUTPUT" seek="$ROOTFS1OFFSET" conv=notrunc
dd bs=512 if="$ROOTFS" of="$OUTPUT" seek="$ROOTFS2OFFSET" conv=notrunc
dd bs=512 if="$DATAFS" of="$OUTPUT" seek="$DATAOFFSET" conv=notrunc
